/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config;

import java.io.PrintStream;

public class IndentedPrinter {
    private static final String INDENT_STEP = "\t";
    private static final int INDENT_CACHE = 20;
    private static final String[] INDENTS = new String[21];
    private PrintStream out;
    private int indent;

    static {
        StringBuffer stringBuffer = new StringBuffer(20 * INDENT_STEP.length());
        int n = 0;
        while (n <= 20) {
            IndentedPrinter.INDENTS[n] = stringBuffer.toString();
            stringBuffer.append(INDENT_STEP);
            ++n;
        }
    }

    public IndentedPrinter(PrintStream printStream) {
        this.out = printStream;
    }

    public void push() {
        ++this.indent;
    }

    public void pop() {
        --this.indent;
    }

    public final String getIndent() {
        if (this.indent <= 20) {
            return INDENTS[this.indent];
        }
        String string = INDENTS[20];
        this.indent -= 20;
        while (this.indent > 0) {
            int n = this.indent < 20 ? this.indent : 20;
            this.indent -= n;
            string = String.valueOf(string) + INDENTS[n];
        }
        return string;
    }

    public final void print() {
        this.out.print(this.getIndent());
    }

    public final void println() {
        this.out.println();
    }

    public final void print(String string) {
        this.out.print(String.valueOf(this.getIndent()) + string);
    }

    public final void println(String string) {
        this.out.println(String.valueOf(this.getIndent()) + string);
    }

    public final void print(StringBuilder stringBuilder) {
        this.out.print(String.valueOf(this.getIndent()) + stringBuilder);
    }

    public final void println(StringBuilder stringBuilder) {
        this.out.println(String.valueOf(this.getIndent()) + stringBuilder);
    }
}

